import logging
import sys
import os
import time


class Logger(object):
    level_relations = {
        'debug': logging.DEBUG,
        'info': logging.INFO,
        'warning': logging.WARNING,
        'error': logging.ERROR,
        'critical': logging.CRITICAL
    }

    def __init__(self, file_name, level='info',
                 fmt='%(asctime)s - %(levelname)s: %(message)s'):
        self.logger = logging.getLogger(file_name)
        self.file_name = file_name

        # 设置日志格式
        self.format_str = logging.Formatter(fmt)

        # 设置日志级别
        self.logger.setLevel(self.level_relations.get(level))

    def output_console(self):
        # 往屏幕上输出
        sh = logging.StreamHandler()
        sh.setFormatter(self.format_str)
        self.logger.addHandler(sh)
        return sh

    def output_file(self):
        # 将日志写到文件里面
        th = logging.FileHandler(self.file_name,
                                 encoding='utf-8')
        th.setFormatter(self.format_str)
        self.logger.addHandler(th)
        return th

    def remove_handler(self, handler):
        self.logger.removeHandler(handler)

    def __call__(self, message):
        sh = self.output_console()
        th = self.output_file()

        self.logger.info(message)

        self.remove_handler(sh)
        self.remove_handler(th)


def get_logger(log_path):
    time_format = "%m/%d %H:%M:%S"
    fmt = "[%(asctime)s] %(levelname)s (%(name)s) %(message)s"
    formatter = logging.Formatter(fmt, time_format)
    logger = logging.getLogger()
    logger.setLevel(logging.INFO)
    if logger.hasHandlers():
        logger.handlers.clear()

    handler = logging.StreamHandler(sys.stdout)
    handler.setFormatter(formatter)
    logger.addHandler(handler)

    fileHandler = logging.FileHandler(filename=log_path + "_" + time.strftime('%Y-%m-%d %H:%M:%S', time.localtime()))
    fileHandler.setLevel(logging.INFO)
    formatterFile = logging.Formatter("%(message)s")
    fileHandler.setFormatter(formatterFile)
    logger.addHandler(fileHandler)

    return logger


def encoded_arch(nasbench, data, deterministic, dataset):
    encoded_arch_data = []

    if len(data) == 1:
        encoded_arch_data.append(nasbench.dag_encoding(data[0], deterministic=deterministic, dataset=dataset))
    else:
        for strArch in data:
            encoded_arch_data.append(nasbench.dag_encoding(strArch[0], deterministic=deterministic, dataset=dataset))

    return encoded_arch_data




